const target = document.querySelector('h1');

/* if(target) {
    target.insertAdjacentHTML('afterend', "<p id='special-extension-subtitle'>Are You Dyslexic? </p>");
} */

const textCollection = document.querySelectorAll("h1, h2, h3, h4, h5, h6, p, span, a, li, figcaption");
const letterRegex = /[A-Za-zÀ-ÖØ-öø-ÿ]+/g;
const keepChance = 0.40;
const intervalMs = 1500; 

const originalTextMap = new WeakMap();

function shuffleArray(arr) {
    for (let i = arr.length - 1; i > 0; i--) {
        const j = Math.floor(Math.random() * (i + 1));
        [arr[i], arr[j]] = [arr[j], arr[i]];
    }
}

// try random shuffles first, then a greedy reorganization if needed
function arrangeMiddleAvoidAdj(middleArr, firstChar, lastChar) {
    if (middleArr.length <= 1) return middleArr;

    const testNoAdj = (arr) => {
        let prev = firstChar;
        for (let i = 0; i < arr.length; i++) {
            if (arr[i] === prev) return false;
            prev = arr[i];
        }
        if (lastChar && prev === lastChar) return false;
        return true;
    };

    // attempt random shuffles
    for (let attempt = 0; attempt < 30; attempt++) {
        shuffleArray(middleArr);
        if (testNoAdj(middleArr)) return middleArr.slice();
    }

    // greedy rearrange by frequency (like "reorganize string")
    const counts = {};
    for (const ch of middleArr) counts[ch] = (counts[ch] || 0) + 1;
    const result = [];
    let prev = firstChar;

    while (Object.keys(counts).length) {
        // pick char with highest count that is != prev
        let pick = null;
        let maxCount = -1;
        for (const ch of Object.keys(counts)) {
            if (ch === prev) continue;
            if (counts[ch] > maxCount) { pick = ch; maxCount = counts[ch]; }
        }
        if (!pick) return null; // cannot place without adjacent equal

        result.push(pick);
        counts[pick]--;
        if (counts[pick] === 0) delete counts[pick];
        prev = pick;
    }

    // final check vs lastChar; try swap last two if conflict and safe
    if (lastChar && result.length && result[result.length - 1] === lastChar) {
        if (result.length >= 2 && result[result.length - 2] !== lastChar && result[result.length - 2] !== result[result.length - 3]) {
            const tmp = result[result.length - 1];
            result[result.length - 1] = result[result.length - 2];
            result[result.length - 2] = tmp;
            if (result[result.length - 1] === lastChar) return null;
        } else {
            return null;
        }
    }

    return result;
}

function jumbleWord(word) {
    // do not jumble short words or acronyms (all uppercase)
    if (word.length <= 2 || word === word.toUpperCase()) return word;

    // special-case 3-letter words: rotate middle/last so something actually changes
    if (word.length === 3) {
        const candidate = word[0] + word[2] + word[1];
        if (!/(.)\1/.test(candidate)) return candidate;
        return word;
    }

    const first = word[0];
    const last = word[word.length - 1];
    const middle = word.slice(1, -1).split('');
    const n = middle.length;
    const k = Math.min(3, n); // jumble up to 3 letters in the middle

    // helper: sample k distinct indices from 0..n-1
    function sampleIndices(n, k) {
        const idx = Array.from({ length: n }, (_, i) => i);
        shuffleArray(idx);
        return idx.slice(0, k);
    }

    // try multiple attempts: pick k positions, shuffle only those letters, reject if creates adjacent identical letters
    for (let attempt = 0; attempt < 60; attempt++) {
        const picks = sampleIndices(n, k);
        const middleCopy = middle.slice();
        const letters = picks.map(i => middleCopy[i]);
        shuffleArray(letters);
        for (let i = 0; i < picks.length; i++) middleCopy[picks[i]] = letters[i];
        const candidate = first + middleCopy.join('') + last;
        if (!/(.)\1/.test(candidate)) return candidate;
    }

    // fallback: if we couldn't produce a valid candidate by shuffling only k letters,
    // attempt a full rearrangement that avoids adjacent equals (existing helper)
     /* const arranged = arrangeMiddleAvoidAdj(middle.slice(), first, last);
    if (arranged && arranged.length) {
        return first + arranged.join('') + last;
    } */

    // last resort: return original word unchanged
    /* return word; */
}

function jumbleText(original) {
    // For each matched word, sometimes keep the original, otherwise return a freshly jumbled version
    return original.replace(letterRegex, (match) => {
        if (Math.random() < keepChance) return match;
        return jumbleWord(match);
    });
}

// apply continuously to text nodes only (preserves element structure and attributes)
setInterval(() => {
    const textCollection = document.querySelectorAll("h1, h2, h3, h4, h5, h6, p, span, a, li, figcaption");
    textCollection.forEach(el => {
        const childNodes = Array.from(el.childNodes);
        childNodes.forEach(n => {
            if (n.nodeType === Node.TEXT_NODE) {
                if (!originalTextMap.has(n)) originalTextMap.set(n, n.nodeValue);
                const original = originalTextMap.get(n) || '';
                const newText = jumbleText(original);
                if (newText !== n.nodeValue) n.nodeValue = newText;
            }
        });
    });
}, intervalMs);

/* textCollection.forEach(text => {
    const randomEmojis = ["😀","😂","😍","😎","🤓","😡","🤠","🥳","😴","🤖","👻","💩","👽","🎃","🙃","🤑"];
    const randomIndex = Math.floor(Math.random() * randomEmojis.length);
    const emoji = randomEmojis[randomIndex];
    text.textContent = emoji + " " + text.textContent + " " + emoji;
}) */